#!/bin/bash

#
# Copyright (c) 2012-2019 Huawei .
# All rights reserved.
#
# Please send feedback to http://www.huawei.com
#
# Function

# revise note

######################################
set +x

CUR_USER=$(whoami)
if [ "$CUR_USER" != "hcpprocess" ];then
    echo "This script must run as hcpprocess user, please use \"su -s /bin/bash hcpprocess\"."
    exit 1
fi

SCRIPT_HOME="$(cd "$(dirname "$0")"; pwd)"
SERVICE_HOME="$(cd "${SCRIPT_HOME}/../";pwd)"


source ${SERVICE_HOME}/script/ebackup_ms_profile.sh
source ${SERVICE_HOME}/script/utils/log.sh
source ${G_HOME_PATH}/bin/ebackup_common.sh

LOG_FILE_PATH="${SERVICE_HOME}/logs/metadata_oper.log"
set_logfile_path "${LOG_FILE_PATH}"



#******************************************************************#
# Function: program_usage
# Description: The function give a manual
# Input Parameters:
# None
# Returns:
#******************************************************************#
function program_usage ()
{
    cat << END

metadata_oper.sh backup      Get status of  process
metadata_oper.sh -h                        Show help for this hcp_checked_processes.sh

END
        return ${EX_HCP_PM_OPERATOR_SUCCESS}
}

function packageAllFilesInternal()
{
    [ $# -lt 3 ] && { log_error "function packageAllFiles's parameters number less than 3.";return 1; }
    local srcPath="$1";
    local srcDir="$2";
    local dstFile="$3";
    tar -zcf "${dstFile}" -C "${srcPath}" "${srcDir}" || { log_error "tar ${dstFile} failed. ret:$?";return 1; }
    tar -tf "${dstFile}" || { log_error "tar verify ${dstFile} failed. ret:$?";return 1; }
    rm -rf "${srcPath}/${srcDir}" || { log_error "rm destDir ${dstPath}/${serverName}/${serverName} failed,ret is:$?"; }
}

function packageAllFiles()
{
    log_info "starting to packageAllFiles meatadata.";
    local cfgFile="${SERVICE_HOME}/conf/hcpconf.ini";
    local serverName=$(_get_hcp_cfg "General" "MicroServiceName" "${cfgFile}")
    local dstPath="${SERVICE_HOME}/tmp";
    exec 2>>${LOG_FILE_PATH}
    exec 1>>${LOG_FILE_PATH}
    packageAllFilesInternal "${dstPath}" "${serverName}" "${dstPath}/${serverName}.tar.gz" || { return $?; }
    log_info "finished to packageAllFiles meatadata.";
}

function backup()
{
    log_info "starting to backup meatadata.";
    local backupScript="${SCRIPT_HOME}/backup_metadata.sh";
    if [ -f "${backupScript}" ]; then
        log_info "there already exists script file:${backupScript},invoke it to backup.";
        sh "${backupScript}";
        local iRet=$?
        log_info "the result invoke script:${backupScript} is:${iRet}";
        return ${iRet};
    fi

    log_info "no special scrip to backup,use the default function to backup it.";
    local cfgFile="${SERVICE_HOME}/conf/hcpconf.ini";
    local serverName=$(_get_hcp_cfg "General" "MicroServiceName" "${cfgFile}")
    local dstPath="${SERVICE_HOME}/tmp";
    exec 2>>${LOG_FILE_PATH}
    exec 1>>${LOG_FILE_PATH}
    local pkgFileDir="${dstPath}/${serverName}/${serverName}";
    mkdir -p "${pkgFileDir}" || { log_error "create dir ${pkgFileDir} failed."; return 1; }
    cp -r "${SERVICE_HOME}"/conf/{odbc.ini,hcpconf.ini,secret.ini,dbkey,kmc} "${pkgFileDir}" || { log_error "copy files to dir ${pkgFileDir} failed,ret is:$?"; }

    [ -e "${SERVICE_HOME}/conf/occert.pem" ] && ( cp -r "${SERVICE_HOME}/conf/occert.pem" "${pkgFileDir}" || log_error "copy files to dir ${pkgFileDir} failed,ret is:$?"; )
    [ -e "${SERVICE_HOME}/conf/ockey" ] && ( cp -r "${SERVICE_HOME}/conf/ockey" "${pkgFileDir}" || log_error "copy files to dir ${pkgFileDir} failed,ret is:$?"; )

    packageAllFilesInternal "${dstPath}/${serverName}" "${serverName}" "${dstPath}/${serverName}/${serverName}.bin"
    log_info "finished to backup meatadata.";
    # add verify info
}

function set_dir_permission()
{
    find $1 -type f | while read file; do
        set_permission ${file} $2
        if [ $? -ne 0 ];then
            return 1
        fi
    done
}


function set_permission()
{
    chmod $2 $1
    if [ $? -ne 0 ];then
        log_error "Error:Perform chmod $2 $1 error,Please Contact Huawei technical support."
        return 1
    fi
}

#
# in the fact,wo should restore all the files in this function,just as a opposite operate with backup and packageAllFiles.
# but for the implements of the SecurityTool do's. wo just implements part of recovery.
#
function restore()
{
    log_info "starting to restore meatadata.";
    local cfgFile="${SERVICE_HOME}/conf/hcpconf.ini";
    local dstPath="${SERVICE_HOME}/tmp";
    local serverName=$(_get_hcp_cfg "General" "MicroServiceName" "${cfgFile}")
    [ ! -f "${cfgFile}" ] && { serverName=$(echo "${SERVICE_HOME}" | sed "s@/\$@@" | sed "s@.*/@@g"); }

    local restoreScript="${SCRIPT_HOME}/${serverName}_restore.sh";
    if [ -f "${restoreScript}" ]; then
        log_info "there already exists script file:${restoreScript},invoke it to restore.";
        set_permission ${SERVICE_HOME}/conf/kmc/bak/  "700" || { log_error "failed to set_permission ${SERVICE_HOME}/conf/kmc.";return 1; }
        set_dir_permission ${SERVICE_HOME}/conf/kmc/bak/  "700" || { log_error "failed to set_permission ${SERVICE_HOME}/conf/kmc.";return 1; }
        sh "${restoreScript}";
        local iRet=$?
        log_info "the result invoke script:${restoreScript} is:${iRet}";
        set_dir_permission ${SERVICE_HOME}/conf/kmc/bak/  "400" || { log_error "failed to set_permission ${SERVICE_HOME}/conf/kmc/bak.";return 1; }
        return ${iRet};
    fi

    log_info "no special scrip to restore,use the default function to restore it.";
    exec 2>>${LOG_FILE_PATH}
    exec 1>>${LOG_FILE_PATH}

    log_info "ready to restore files:{hcpconf.ini,secret.ini,odbc.ini,dbkey,kmc}..."
    set_permission ${SERVICE_HOME}/conf/kmc/bak/ "700" || { log_error "failed to set_permission ${SERVICE_HOME}/conf/kmc.";return 1; }
    cp -rf ${SERVICE_HOME}/tmp/${serverName}/${serverName}/{hcpconf.ini,secret.ini,odbc.ini,dbkey,kmc} ${SERVICE_HOME}/conf || { log_error "failed to cp ${SERVICE_HOME}/tmp/${serverName}/${serverName}/{hcpconf.ini,secret.ini,odbc.ini,dbkey,kmc}.";return 1; }
    local floatIp=$(grep 'LoadbalanceAddress=' ${SERVICE_HOME}/conf/hcpconf.ini | awk -F'//' '{print $2}')
    sed -i "s/LoadbalanceAddress=https:\/\/.*/LoadbalanceAddress=https:\/\/${floatIp}/g" ${SERVICE_HOME}/conf/hcpconf.ini || { log_error "failed to change IP to ${floatIp}";return 1; }
    set_permission ${SERVICE_HOME}/conf/hcpconf.ini "640" || { log_error "failed to set_permission ${SERVICE_HOME}/tmp/${serverName}/${serverName}/hcpconf.ini .";return 1; }
    set_permission ${SERVICE_HOME}/conf/secret.ini "640" || { log_error "failed to set_permission ${SERVICE_HOME}/tmp/${serverName}/${serverName}/secret.ini .";return 1; }
    set_permission  ${SERVICE_HOME}/conf/odbc.ini  "600" || { log_error "set permission ${SERVICE_HOME}/conf/odbc.ini failed.";return 1; }
    set_permission ${SERVICE_HOME}/conf/dbkey "600"  || { log_error "failed to set_permission ${SERVICE_HOME}/conf/dbkey ";return 1; }
    set_permission ${SERVICE_HOME}/conf/kmc "750" || { log_error "failed to set_permission ${SERVICE_HOME}/conf/kmc.";return 1; }
    set_dir_permission ${SERVICE_HOME}/conf/kmc/bak/ "400" || { log_error "failed to set_permission ${SERVICE_HOME}/conf/kmc/bak.";return 1; }
    #restore oc
    if [ -f "${SERVICE_HOME}/tmp/${serverName}/${serverName}/ockey" ]; then
        log_info "ready to restore file: from ${SERVICE_HOME}/tmp/${serverName}/${serverName}/ockey to ${SERVICE_HOME}/conf..."
        cp ${SERVICE_HOME}/tmp/${serverName}/${serverName}/ockey  ${SERVICE_HOME}/conf || { log_error "failed to cp ${SERVICE_HOME}/tmp/${serverName}/${serverName}/ockey ."; }
        set_permission ${SERVICE_HOME}/conf/ockey "600" || { log_error "failed to set_permission ${SERVICE_HOME}/conf/ockey.";return 1; }

    fi
    rm -rf ${SERVICE_HOME}/tmp/* || { log_error "remove the files:${SERVICE_HOME}/tmp/* failed,ret is:$?"; }
    log_info "success to restore the metadata of service:${serverName}."
    return 0;
}

#******************************************************************#
# Function: main
# Description: The function is the begin of the program
# Input Parameters:
# $1: show/set
# None
# Returns:
#******************************************************************#

function main()
{
     local iRet=""

     while [ -n "$1" ]
     do
         case "$1" in
         backup)
             shift 1 && backup "$@"
             iRet=$?
             log_info "execute backup $*,ret:${iRet}";
             exit ${iRet};
             ;;
         packageAllFiles)
             shift 1 && packageAllFiles "$@";
             iRet=$?
             log_info "execute packageAllFiles $*,ret:${iRet}";
             exit ${iRet};
             ;;
         restore)
             shift 1 && restore "$@";
             iRet=$?
             log_info "execute restore $*,ret:${iRet}";
             exit ${iRet};
             ;;
         -h)
             shift 1 && program_usage "$@"
             iRet=$?
             log_info "execute program_usage $*,ret:${iRet}";
             exit ${iRet};
             ;;

         *)
            program_usage
            exit 1;
           ;;
        esac
done
}
##############################################################
##############################################################


main "$@"

exit $?
